import '../sass/public.scss';

import jQuery from 'jquery';

( function ( $ ) {
	const setSelected = () => {
		const selectedMethod = $(
			'input[name=qls_shipment_method]:checked'
		).closest( '.qls-shipment-method' );

		$( '.qls-shipment-method' )
			.not( selectedMethod )
			.removeClass( 'selected' );
		selectedMethod.addClass( 'selected' );
	};

	$( document ).ready( () => {
		setSelected();

		$( 'body' )
			.on( 'updated_checkout', setSelected )
			.on( 'change', 'input[name=qls_shipment_method]', setSelected )
			.on(
				'change',
				'.qls-shipment-method input, .qls-shipment-method select',
				() => $( 'body' ).trigger( 'update_checkout' )
			);
	} );
} )( jQuery );
