<?php
/*
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/qls-shipment-methods.php.
*/

defined('ABSPATH') || exit;

/** @var bool $is_shipping_available */
/** @var bool $are_shipping_methods_customer_address_based */
/** @var array $shipping_methods */

$customer = WC()->cart->get_customer();
?>

<div class="qls-shipment-methods">
    <h3><?= __('Choose a shipping method', 'qls-shipment') ?></h3>

    <?php
    if (!$is_shipping_available || !$are_shipping_methods_customer_address_based) {
        echo '<p>' . __('Enter your address details to view the available shipping options.', 'qls-shipment') . '</p>';
    } else if (!$shipping_methods) {
        echo '<p>' . __('Unable to fetch shipping methods. Continue without selecting a shipping method.', 'qls-shipment') . '</p>';
    } else {
        $session_chosen_method = WC()->session->get('chosen_shipping_methods')[0] ?? null;
        $chosen_method = $session_chosen_method ?? $shipping_methods[0]['id'];

        foreach ($shipping_methods as $shipping_method) {
            $selected_method = $chosen_method === 'qls-shipment-' . $shipping_method['id'];
            ?>
            <div class="qls-shipment-method <?= $selected_method ? 'selected' : '' ?>">
                <div class="qls-shipment-method-header">
                    <div class="qls-shipment-method-header-name-group">
                        <input type="radio" name="qls_shipment_method"
                               id="qls_shipment_method_<?= $shipping_method['id'] ?>"
                               value="<?= $shipping_method['id'] ?>" <?= $selected_method ? 'checked' : '' ?>>
                        <label for="qls_shipment_method_<?= $shipping_method['id'] ?>"
                               class="qls-shipment-method-header-name-group-name">
                            <?= $shipping_method['title'] ?>
                        </label>
                    </div>
                    <span class="qls-shipment-method-header-price">
                        <?php
                        if ($shipping_method['price_incl'] === 0) {
                            echo __('Free shipping', 'qls-shipment');
                        } else {
                            echo wc_price($shipping_method['price_incl']);
                        }
                        ?>
                    </span>
                </div>
                <?php
                if (!empty($shipping_method['description'])) {
                    ?>
                    <div class="qls-shipment-method-description">
                        <?= $shipping_method['description'] ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if (count($shipping_method['options']) > 0) {
                    ?>
                    <div class="qls-shipment-method-options">
                        <?php
                        foreach ($shipping_method['options'] as $key => $option) {
                            $session_option_key = WC()->session->get('chosen_qls-shipment-method-' . $shipping_method['id'] . '-option-' . $key);
                            $chosen_option_key = $session_option_key ?? $option['values'][0];
                            ?>
                            <div class="qls-shipment-method-options-option">
                                <label class="qls-shipment-method-options-option-label"
                                       for="qls-shipment-method-<?= $shipping_method['id'] ?>-option-<?= $key ?>"><?= $option['label'] ?></label>
                                <?php
                                if ($option['type'] === 'select') {
                                    ?>
                                    <select class="qls-shipment-method-options-option-input"
                                            name="qls-shipment-method-<?= $shipping_method['id'] ?>-option-<?= $key ?>"
                                            id="qls-shipment-method-<?= $shipping_method['id'] ?>-option-<?= $key ?>">
                                        <?php
                                        foreach ($option['values'] as $value_key => $value) {
                                            ?>
                                            <option value="<?= $value_key ?>" <?= $value_key === $chosen_option_key ? 'selected' : '' ?>><?= $value ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                    <?php
                                }
                                ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <?php
                }
                ?>
            </div>
            <?php
        }
    }
    ?>
</div>
