<?php
/*
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-shipping.php.
*/

defined('ABSPATH') || exit;

/** @var string $package_name */
/** @var array $available_methods */
/** @var string $chosen_method */

/** @var WC_Shipping_Rate $method */
$method = $available_methods[$chosen_method];
?>
<tr class="woocommerce-shipping-totals shipping">
    <th><?php echo wp_kses_post($package_name); ?></th>
    <?php
    if ($chosen_method) {
        ?>
        <td data-title="<?php echo esc_attr($package_name); ?>">
            <?php
            $price = $available_methods[$chosen_method]->get_cost() + array_sum($available_methods[$chosen_method]->get_taxes());
            
            if ($price === 0) {
                echo __('Free shipping', 'qls-shipment');
            } else {
                echo wc_price($price);
            }
            ?>
        </td>
        <?php
    } else {
        if (is_cart()) {
            ?>
            <td><?= __('Shipment costs are calculated at checkout.', 'qls-shipment') ?></td>
            <?php
        } else {
            ?>
            <td><?= __('Enter your address details to view the available shipping options.', 'qls-shipment') ?></td>
            <?php
        }
    }
    ?>
</tr>
