<?php

/**
 * The file that defines the core plugin class
 */
class Qls_Shipment
{

    protected $loader;

    protected $plugin_name;

    protected $version;

    public function __construct()
    {
        if (defined('QLS_SHIPMENT_VERSION')) {
            $this->version = QLS_SHIPMENT_VERSION;
        } else {
            $this->version = '1.0.0';
        }
        $this->plugin_name = 'qls-shipment';

        $this->load_dependencies();
        $this->set_locale();
        $this->define_admin_hooks();

        if (!(new Qls_Shipment_Settings())->all_required_settings_set()) {
            return;
        }

        $this->define_public_hooks();
    }

    public function get_plugin_name(): string
    {
        return $this->plugin_name;
    }

    public function get_version(): string
    {
        return $this->version;
    }

    private function load_dependencies(): void
    {

        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-qls-shipment-logger.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-qls-shipment-loader.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-qls-shipment-i18n.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-qls-shipment-api.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-qls-shipment-settings.php';

        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-qls-shipment-admin.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-qls-shipment-settingspage.php';

        require_once plugin_dir_path(dirname(__FILE__)) . 'public/class-qls-shipment-cart.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/class-qls-shipment-checkout.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/class-qls-shipment-public.php';

        $this->loader = new Qls_Shipment_Loader();
    }

    private function set_locale(): void
    {
        $plugin_i18n = new Qls_Shipment_i18n();

        $this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');
    }

    private function define_admin_hooks(): void
    {
        $plugin_admin = new Qls_Shipment_Admin($this->get_plugin_name(), $this->get_version());

        $plugin_admin->define_hooks($this->loader);
    }

    private function define_public_hooks(): void
    {

        $plugin_public = new Qls_Shipment_Public($this->get_plugin_name(), $this->get_version());

        $plugin_public->define_hooks($this->loader);
    }

    public function run(): void
    {
        $this->loader->run();
    }

}
