<?php

/**
 * Contains all setting keys and helpers
 */
class Qls_Shipment_Settings
{

    /** @var string[] Keys for required settings */
    protected array $required_settings = [
        'qls_shipment_api_endpoint',
        'qls_shipment_api_username',
        'qls_shipment_api_password',
        'qls_shipment_integration_id',
        'qls_shipment_free_shipment_calculation_method',
    ];

    /** @var string[] Keys for optional settings */
    protected array $optional_settings = [
        'qls_shipment_fallback_price'
    ];

    public function __construct()
    {
    }

    /**
     * Registers all settings for the plugin.
     *
     * @return void
     */
    public function register(): void
    {
        foreach (array_merge($this->required_settings, $this->optional_settings) as $key) {
            register_setting('qls-shipment-settings', $key);
        }
    }

    /**
     * Check if all required settings are set.
     *
     * @return bool
     */
    public function all_required_settings_set(): bool
    {
        foreach ($this->required_settings as $key) {
            if (!get_option($key)) {
                return false;
            }
        }

        return true;
    }
}
