<?php

/**
 * The admin-specific functionality of the plugin.
 */
class Qls_Shipment_Admin
{

    private Qls_Shipment_Settings $qls_shipment_settings;
    private Qls_Shipment_SettingsPage $qls_shipment_settingspage;

    public function __construct(private string $plugin_name, private string $version)
    {
        $this->qls_shipment_settings = new Qls_Shipment_Settings();
        $this->qls_shipment_settings->register();

        $this->qls_shipment_settingspage = new Qls_Shipment_SettingsPage($plugin_name, $version, $this->qls_shipment_settings);
    }

    public function define_hooks(Qls_Shipment_Loader $loader): void
    {
        $this->qls_shipment_settingspage->define_hooks($loader);

        $loader->add_action('admin_init', $this, 'display_qls_shipping_disabled_warning');
        $loader->add_action('woocommerce_settings_shipping', $this, 'display_shipping_zones_disabled_warning');
    }

    /**
     * Display a warning to the user when not all required settings are set.
     *
     * @return void
     */
    public function display_qls_shipping_disabled_warning(): void
    {
        if ($this->qls_shipment_settings->all_required_settings_set()) {
            return;
        }

        ?>
        <div class="notice notice-warning">
            <p>
                <?=
                sprintf(
                // translators: %s will be replaced by the URL to the settings page.
                    __('Not all settings are set for the QLS Shipment plugin. The plugin is deactivated until all settings are set. <a href="%s">Check the settings page</a>.', 'qls-shipment'),
                    esc_url(add_query_arg(
                        'page',
                        'qls-shipment-settings',
                        get_admin_url() . 'options-general.php'
                    )))
                ?>
            </p>
        </div>
        <?php
    }

    /**
     * Display a warning to the user that shipping zones are disabled when the QLS plugin is enabled.
     *
     * @return void
     */
    public function display_shipping_zones_disabled_warning(): void
    {
        global $current_section;

        if ('' !== $current_section) {
            return;
        }
        ?>
        <div class="notice notice-warning">
            <p><?= __('The shipping zone settings are disabled, because you have enabled the QLS Shipment plugin. Settings you modify here have no impact on the actual shipping methods offered.', 'qls-shipment') ?></p>
        </div>
        <?php
    }

}
