define([
    'jquery',
    'ko',
    'uiComponent',
    'Magento_Checkout/js/model/quote'
], function ($, ko, Component, quote) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'qls_shipping/view/checkout/shipping/carrier_custom',
            baseQlsUrl: 'https://embed.pakketdienstqls.nl/',
            defaultCountryId: 'NL',
            defaultPostcode: '',
            iframeElement: '#qls_servicepoint_locator',
            QLSLocatorVisible: false,
            SelectedServicePoint: {},
            SelectedServicePointName: '',
            SelectedServicePointCode: '',
        },

        initObservable: function () {

            this.selectedMethod = ko.computed(function () {
                var method = quote.shippingMethod();
                var selectedMethod = method != null ? method.carrier_code + '_' + method.method_code : null;

                if (selectedMethod === "qlsservicepoint_qlsservicepoint") {
                    $(".action.continue").prop("disabled", true);
                    $(".qls-servicepoint-warning").css("display", "block");
                } else {
                    $(".action.continue").prop("disabled", false);
                    $(".qls-servicepoint-warning").css("display", "none");
                }

                let servicePoint = $("#selected-service-point-txt").text();

                if (servicePoint.length > 0) {
                    $(".action.continue").prop("disabled", false);
                    $(".qls-servicepoint-warning").css("display", "none");
                }

                return selectedMethod;
            }, this);

            this.QLSLocatorVisible = ko.observable(false);
            this.SelectedServicePoint = ko.observable({});

            var shippingAddress = quote.shippingAddress();
            var servicepointName = window.checkoutConfig.quoteData['qls_servicepoint_name'];
            var servicepointCode = window.checkoutConfig.quoteData['qls_servicepoint_code'];
            if (shippingAddress && shippingAddress.customAttributes !== undefined) {
                servicepointName = shippingAddress.customAttributes.qls_servicepoint_name;
                servicepointCode = shippingAddress.customAttributes.servicepoint_code;
            }

            this.SelectedServicePointName = ko.observable(servicepointName);
            this.SelectedServicePointCode = ko.observable(servicepointCode);

            this.SelectedServicePoint.subscribe(function (servicepoint) {
                    // console.log('servicepoint changed: ' + servicepoint);
                    var address = quote.shippingAddress();
                    if (address.customAttributes === undefined) {
                        address.customAttributes = {};
                    }
                    address.customAttributes.qls_servicepoint_code = servicepoint.servicepoint_code;
                    address.customAttributes.qls_servicepoint_name = servicepoint.name;
                    quote.shippingAddress(address);

                    this.SelectedServicePointCode(servicepoint.servicepoint_code);
                    this.SelectedServicePointName(servicepoint.name);
                }.bind(this)
            );

            quote.shippingAddress.subscribe(function (address) {
                    // console.log('address changed');
                    // console.log(address);
                    this.updateIFrameURL(address);
                }.bind(this)
            );

            addEventListener("message", function (event) {
                // console.log('message received');
                // console.log(event);
                var data = event.data;

                if (data && event.origin + "/" == this.baseQlsUrl && data.action == 'qlsLocatorServicePointSelected') {
                    this.qlsLocatorServicePointSelected(data);
                }
            }.bind(this), false);

            return this;
        },

        closeQLSLocator: function () {
            this.QLSLocatorVisible(false);
            return false;
        },

        showQLSLocator: function () {
            this.QLSLocatorVisible(true);
            return false;
        },

        getServicepointButtonText: function () {
            var defaultValue = 'Pickup at servicepoint';
            return window.checkoutConfig.qls_servicepoint ? window.checkoutConfig.qls_servicepoint.button_caption || defaultValue : defaultValue;
        },

        getServicepointCompanyId: function () {
            return window.checkoutConfig.qls_servicepoint ? window.checkoutConfig.qls_servicepoint.company_id || '' : '';
        },

        updateIFrameURL: function (address) {
            var url = this.getIFrameURL(address);

            // console.log('change URL to ' + url);
            // forces the iframe refresh by clearing the src property first
            var $iframe = $(this.iframeElement);

            if ($iframe.prop('src') !== url) {
                $iframe.prop('src', '');
                // timeout required to allow for iframe reloading
                setTimeout(function () {
                    $iframe.prop('src', url);
                }, 200);
            }
        },

        getIFrameURL: function (address) {
            var country = address && address.countryId ? address.countryId : this.defaultCountryId;
            var postcode = address && address.postcode ? address.postcode : this.defaultPostcode;

            var url = this.baseQlsUrl + '/servicepoint/locator/' + country + '/?companyId=' + this.getServicepointCompanyId() + '#postalcode=' + postcode;

            return url;
        },

        qlsLocatorServicePointSelected: function (data) {
            // hide the iframe
            this.QLSLocatorVisible(false);
            // handle data
            if (data && data.servicepoint) {
                this.SelectedServicePoint(data.servicepoint);
                $(".action.continue").prop("disabled", false);
                $(".qls-servicepoint-warning").css("display", "none");
            }

            /**
             * message structure:
             {
             action: "qlsLocatorServicePointSelected",
             servicepoint: {
             address: {
             country: "NL",
             housenumber: "126",
             locality: "AMSTERDAM",
             postalcode: "1016VB",
             street: "Elandsgracht"
             },
             geo: {
             lat: 52.3692397,
             long: 4.87899117
             },
             name: "Tabaksspeciaalzaak Eland",
             servicepoint_code: "NL-101602",
             times: [
             {formatted: "09:00 - 18:00 uur", from: "09:00:00.000", to: "18:00:00.000", weekday: 2},
             {formatted: "09:00 - 18:00 uur", from: "09:00:00.000", to: "18:00:00.000", weekday: 3},
             {formatted: "09:00 - 18:00 uur", from: "09:00:00.000", to: "18:00:00.000", weekday: 4},
             {formatted: "09:00 - 18:00 uur", from: "09:00:00.000", to: "18:00:00.000", weekday: 5},
             {formatted: "09:00 - 17:00 uur", from: "09:00:00.000", to: "17:00:00.000", weekday: 6}
             ]
             },
             servicepoint_code: "NL-101602"
             }
             */
        }
    });
});
