<?php

namespace Qls\QlsServicePoints\Plugin\Checkout\Model;

use Magento\Checkout\Api\Data\ShippingInformationInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Quote\Model\QuoteRepository;
use Psr\Log\LoggerInterface;
use Qls\QlsServicePoints\Model\QLSServicePointValidator as Validator;

class ShippingInformationManagement
{
    /**
     * @var QuoteRepository
     */
    protected $quoteRepository;
    /**
     * @var LoggerInterface
     */
    protected $logger;
    /**
     * @var Validator
     */
    private $validator;

    /**
     * ShippingInformationManagement constructor.
     *
     * @param QuoteRepository $quoteRepository
     */
    public function __construct(
        QuoteRepository $quoteRepository,
        Validator       $validator,
        LoggerInterface $logger
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->logger = $logger;
        $this->validator = $validator;
    }

    /**
     * @param \Magento\Checkout\Model\ShippingInformationManagement $subject
     * @param $cartId
     * @param ShippingInformationInterface $addressInformation
     */
    public function beforeSaveAddressInformation(
        \Magento\Checkout\Model\ShippingInformationManagement $subject,
                                                              $cartId,
        ShippingInformationInterface                          $addressInformation
    ) {
        $this->logger->debug(__METHOD__);

        $extAttributes = $addressInformation->getExtensionAttributes();
        $qlsServicepointCode = $extAttributes->getQlsServicepointCode();
        $qlsServicepointName = $extAttributes->getQlsServicepointName();
        $quote = $this->quoteRepository->getActive($cartId);
        $quote->setQlsServicepointCode($qlsServicepointCode);
        $quote->setQlsServicepointName($qlsServicepointName);

//        $shippingMethod = $quote->getShippingAddress()->getShippingMethod();
        $shippingMethod = $addressInformation->getShippingCarrierCode() . '_' . $addressInformation->getShippingMethodCode();
        $code = $quote->getQlsServicepointCode();

        $this->logger->debug(__METHOD__ . ' shipping: ' . $shippingMethod . ', code: ' . $code);


        if (!$this->validator->validate($quote, $shippingMethod)) {
            throw new LocalizedException(__('Please select the ServicePoint first.'));
        }

    }
}
