<?php

namespace Qls\QlsServicePoints\Observer;

use Exception;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Quote\Model\Quote;
use Magento\Quote\Model\QuoteRepository;
use Magento\Sales\Model\Order;
use Psr\Log\LoggerInterface;
use Qls\QlsServicePoints\Model\QLSServicePointValidator as Validator;

class SalesModelServiceQuoteSubmitBefore implements ObserverInterface
{
    /**
     * @var LoggerInterface
     */
    protected $logger;
    /**
     * @var State
     */
    protected $state;
    /**
     * @var QuoteRepository
     */
    private $quoteRepository;
    /**
     * @var Validator
     */
    private $validator;

    /**
     * SalesModelServiceQuoteSubmitBefore constructor.
     *
     * @param QuoteRepository $quoteRepository
     * @param Validator $validator
     */
    public function __construct(
        QuoteRepository              $quoteRepository,
        Validator                    $validator,
        State $state,
        LoggerInterface     $logger
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->logger = $logger;
        $this->validator = $validator;
        $this->state = $state;
    }

    /**
     * @param EventObserver $observer
     * @return $this
     * @throws Exception
     */
    public function execute(EventObserver $observer) {
        $this->logger->debug(__METHOD__);

        /** @var Order $order */
        $order = $observer->getOrder();
        /** @var Quote $quote */
        $quote = $this->quoteRepository->get($order->getQuoteId());

        $areaCode = $this->state->getAreaCode();

        $this->logger->debug(__METHOD__ . ' area : ' . $areaCode);

        // do not proceed with the validation in the Admin area
        if ($areaCode!==Area::AREA_ADMINHTML) {
            if (!$this->validator->validate($quote)) {
                throw new LocalizedException(__('Please select the ServicePoint first.'));
            }
        }

        $order->setQlsServicepointCode($quote->getQlsServicepointCode());

        return $this;
    }
}
