<?php

namespace Qls\QlsServicePoints\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\AdminOrder\Create;

class AdminhtmlSalesOrderCreateProcessData implements ObserverInterface
{
    /**
     * @param EventObserver $observer
     * @return $this
     */
    public function execute(EventObserver $observer) {
        $requestData = $observer->getRequest();
        $qlsServicepointCode = isset($requestData['qls_servicepoint_code']) ? $requestData['qls_servicepoint_code']:null;

        /** @var Create $orderCreateModel */
        $orderCreateModel = $observer->getOrderCreateModel();
        $quote = $orderCreateModel->getQuote();
        $quote->setQlsServicepointCode($qlsServicepointCode);

        return $this;
    }
}
