<?php

namespace Qls\QlsServicePoints\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\TemplateFactory;

class AddHtmlToOrderShippingBlock implements ObserverInterface
{
    /**
     * @var TemplateFactory
     */
    protected $templateFactory;

    /**
     * @var TimezoneInterface
     */
    private $timezone;

    /**
     * AddHtmlToOrderShippingBlock constructor.
     *
     * @param TemplateFactory $templateFactory
     * @param TimezoneInterface $timezone
     */
    public function __construct(
        TemplateFactory   $templateFactory,
        TimezoneInterface $timezone
    ) {
        $this->templateFactory = $templateFactory;
        $this->timezone = $timezone;
    }

    /**
     * @param EventObserver $observer
     * @return $this
     */
    public function execute(EventObserver $observer) {
        if ($observer->getElementName()=='sales.order.info') {
            $orderShippingViewBlock = $observer->getLayout()->getBlock($observer->getElementName());
            $order = $orderShippingViewBlock->getOrder();

            /** @var Template $qlsServicepointCodeBlock */
            $qlsServicepointCodeBlock = $this->templateFactory->create();
            $qlsServicepointCodeBlock->setQlsServicepointCode($order->getQlsServicepointCode());
            $qlsServicepointCodeBlock->setTemplate('qls_shipping::order_info_shipping_info.phtml');
            $html = $observer->getTransport()->getOutput() . $qlsServicepointCodeBlock->toHtml();
            $observer->getTransport()->setOutput($html);
        }

        return $this;
    }
}
