<?php

namespace Qls\QlsServicePoints\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

/**
 * Class SampleConfigProvider
 */
class ShippingConfigProvider extends AbstractHelper implements ConfigProviderInterface
{
    /**
     * Retrieve assoc array of checkout configuration
     *
     * @return array
     */
    public function getConfig() {
        $buttonCaption = $this->scopeConfig->getValue(
            'carriers/qlsservicepoint/servicepoint_button_caption',
            ScopeInterface::SCOPE_STORE
        );

        $companyId = $this->scopeConfig->getValue(
            'carriers/qlsservicepoint/companyid',
            ScopeInterface::SCOPE_STORE
        );

        return [
            'qls_servicepoint' => [
                'button_caption' => $buttonCaption,
                'company_id' => $companyId,
            ],
        ];
    }
}
