<?php


namespace Qls\QlsServicePoints\Model;


use Magento\Quote\Model\Quote;

class QLSServicePointValidator
{

    /**
     * Validator constructor.
     */
    public function __construct() {}

    /**
     * @param Quote $quote
     * @return bool
     */
    public function validate(Quote $quote, $shippingMethod = null) {
        if ($quote) {
            if (!$shippingMethod) {
                $shippingMethod = $quote->getShippingAddress()->getShippingMethod();
            }
            $code = $quote->getQlsServicepointCode();

            if ($shippingMethod=='qlsservicepoint_qlsservicepoint') {
                if (empty($code)) {
                    return false;
                }
            }
        }

        return true;
    }
}
