<?php

namespace Qls\QlsServicePoints\Model\Plugin;

use Magento\Sales\Api\Data\OrderExtensionFactory;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\Data\OrderSearchResultInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

class OrderRepository
{

    /**
     * @var OrderExtensionFactory
     */
    protected $orderExtensionFactory;

    /**
     * OrderRepositoryPlugin constructor
     *
     * @param OrderExtensionFactory $orderExtensionFactory
     */
    public function __construct(OrderExtensionFactory $orderExtensionFactory) {
        $this->orderExtensionFactory = $orderExtensionFactory;
    }

    /**
     * Add "qls_servicepoint_code" extension attribute to order data object to make it accessible in API data
     *
     * @param OrderRepositoryInterface $subject
     * @param OrderInterface $order
     *
     * @return OrderInterface
     */
    public function afterGet(OrderRepositoryInterface $subject, OrderInterface $order): OrderInterface {
        $extensionAttributes = $order->getExtensionAttributes();


        if ($extensionAttributes) {
            $extensionAttributes = $order->getExtensionAttributes();
            $extensionAttributes = $extensionAttributes ?:$this->orderExtensionFactory->create();
            $extensionAttributes->setQlsServicepointCode($order->getQlsServicepointCode());

            $order->setExtensionAttributes($extensionAttributes);
        }
        return $order;
    }

    /**
     * Add "qls_servicepoint_code" extension attribute to order data object to make it accessible in API data
     *
     * @param OrderRepositoryInterface $subject
     * @param OrderSearchResultInterface $searchResult
     *
     * @return OrderSearchResultInterface
     */
    public function afterGetList(OrderRepositoryInterface $subject, OrderSearchResultInterface $searchResult): OrderSearchResultInterface {
        $orders = $searchResult->getItems();

        foreach ($orders as &$order) {
            $extensionAttributes = $order->getExtensionAttributes();
            $extensionAttributes = $extensionAttributes ?:$this->extensionFactory->create();
            $extensionAttributes->setQlsServicepointCode($order->getQlsServicepointCode());
            $order->setExtensionAttributes($extensionAttributes);
        }

        return $searchResult;
    }
}
