<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Qls\QlsServicePoints\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

/**
 * @api
 * @since 100.0.2
 */
class Shipping implements ArrayInterface
{
    /**
     * @var \Qls\QlsServicePoints\Model\Carrier\Shipping
     */
    protected $_carrierTablerate;

    /**
     * @param \Qls\QlsServicePoints\Model\Carrier\Shipping $carrierTablerate
     */
    public function __construct(\Qls\QlsServicePoints\Model\Carrier\Shipping $carrierTablerate) {
        $this->_carrierTablerate = $carrierTablerate;
    }

    /**
     * @return array
     */
    public function toOptionArray() {
        $arr = [];
        foreach ($this->_carrierTablerate->getCode('condition_name') as $k => $v) {
            $arr[] = ['value' => $k, 'label' => $v];
        }
        return $arr;
    }
}
